<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Merma extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->admin_model('Merma_model');
        $this->load->library('form_validation');
    }

    public function index()
    {
        $this->data['mermas'] = $this->Merma_model->getAllMermas();
        $this->page_construct('merma/index', $this->data, 'Mermas');
    }

    public function add()
    {
        $this->form_validation->set_rules('nombre', 'Nombre', 'required');

        if ($this->form_validation->run() == true) {
            $data = [
                'nombre'      => $this->input->post('nombre'),
                'descripcion' => $this->input->post('descripcion'),
                'cantidad'    => $this->input->post('cantidad'),
                'created_at'  => date('Y-m-d H:i:s')
            ];

            if ($this->Merma_model->addMerma($data)) {
                $this->session->set_flashdata('message', lang('merma_added'));
                admin_redirect('mermas');
            }
        } else {
            $this->load->view($this->theme . 'admin/merma/add'); // modal
        }
    }
}
