<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<script>
var mTable;
$(document).ready(function () {
    mTable = $('#MermaData').dataTable({
        "aaSorting": [[1, "desc"]],
        "aLengthMenu": [[10, 25, 50, 100, -1],[10, 25, 50, 100, "<?= lang('all') ?>"]],
        "iDisplayLength": <?= $Settings->rows_per_page ?>,
        'bProcessing': true,
        'bServerSide': true,
        'sAjaxSource': '<?= admin_url('merma/getMerma') ?>',
        'fnServerData': function (sSource, aoData, fnCallback) {
            aoData.push({"name":"<?= $this->security->get_csrf_token_name() ?>","value":"<?= $this->security->get_csrf_hash() ?>"});
            $.ajax({'dataType':'json','type':'POST','url': sSource, 'data': aoData, 'success': fnCallback});
        },
        'fnRowCallback': function (nRow, aData) {
            nRow.id = aData[0];
            return nRow;
        },
        "aoColumns": [
            {"bSortable": false, "mRender": checkbox}, // checkbox
            null, // created_at
            null, // reference_no
            null, // customer
            null, // product
            null, // quantity
            {"mRender": currencyFormat}, // cost
            null, // status
            null, // action
            {"bSortable": false} // actions
        ]
    }).fnSetFilteringDelay();
});
</script>

<?php if ($Owner || $GP['bulk_actions']) {
    echo admin_form_open('merma/merma_actions', 'id="action-form"');
} ?>

<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa fa-minus-circle"></i> <?= lang('Mermas') ?></h2>

        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#"><i class="icon fa fa-tasks tip" data-placement="left" title="<?= lang('actions') ?>"></i></a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu" aria-labelledby="dLabel">
                        <li>
                            <a href="<?= admin_url('merma/add'); ?>" data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus-circle"></i> <?= lang('new_merma') ?>
                            </a>
                        </li>
                        <li>
                            <a href="#" id="export_excel" data-action="export_excel">
                                <i class="fa fa-file-excel-o"></i> <?= lang('export_to_excel') ?>
                            </a>
                        </li>
                        <li>
                            <a href="#" id="export_pdf" data-action="export_pdf">
                                <i class="fa fa-file-pdf-o"></i> <?= lang('export_to_pdf') ?>
                            </a>
                        </li>
                        <li class="divider"></li>
                        <li>
                            <a href="#" class="bpo" title="<b><?= $this->lang->line('delete_merma') ?></b>"
                               data-content="<p><?= lang('r_u_sure') ?></p><button type='button' class='btn btn-danger' id='delete' data-action='delete'><?= lang('i_m_sure') ?></button> <button class='btn bpo-close'><?= lang('no') ?></button>"
                               data-html="true" data-placement="left">
                                <i class="fa fa-trash-o"></i> <?= lang('delete_merma') ?>
                            </a>
                        </li>
                    </ul>
                </li>

                <?php if (!empty($warehouses)) { ?>
                    <li class="dropdown">
                        <a data-toggle="dropdown" class="dropdown-toggle" href="#"><i class="icon fa fa-building-o tip" data-placement="left" title="<?= lang('warehouses') ?>"></i></a>
                        <ul class="dropdown-menu pull-right tasks-menus" role="menu">
                            <li><a href="<?= admin_url('merma') ?>"><i class="fa fa-building-o"></i> <?= lang('all_warehouses') ?></a></li>
                            <li class="divider"></li>
                            <?php foreach ($warehouses as $warehouse) {
                                echo '<li><a href="' . admin_url('merma/' . $warehouse->id) . '"><i class="fa fa-building"></i>' . $warehouse->name . '</a></li>';
                            } ?>
                        </ul>
                    </li>
                <?php } ?>
            </ul>
        </div>
    </div>

    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">
                <p class="introtext"><?= lang('list_results'); ?></p>
                <div class="table-responsive">
                    <table id="MermaData" class="table table-bordered table-condensed table-hover table-striped">
                        <thead>
                        <tr class="primary">
                            <th style="width:30px; text-align:center;"><input class="checkbox checkth" type="checkbox" name="check"/></th>
                            <th><?= lang('date') ?></th>
                            <th><?= lang('reference_no') ?></th>
                            <th><?= lang('customer') ?></th>
                            <th><?= lang('product') ?></th>
                            <th><?= lang('quantity') ?></th>
                            <th><?= lang('cost') ?></th>
                            <th><?= lang('status') ?></th>
                            <th><?= lang('action') ?></th>
                            <th style="width:65px; text-align:center;"><?= lang('actions') ?></th>
                        </tr>
                        </thead>

                        <tbody><tr><td colspan="10" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td></tr></tbody>

                        <tfoot class="dtFilter">
                        <tr class="active">
                            <th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th>
                            <th style="width:65px; text-align:center;"><?= lang('actions') ?></th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php if ($Owner || $GP['bulk_actions']) { ?>
    <div style="display:none;">
        <input type="hidden" name="form_action" value="" id="form_action"/>
        <?= form_submit('performAction', 'performAction', 'id="action-form-submit"') ?>
    </div>
    <?= form_close() ?>
<?php } ?>
