<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true">
                <i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title"><?= lang('add_certificador'); ?></h4>
        </div>

        <?php 
        $attrib = ['data-toggle' => 'validator', 'role' => 'form', 'id' => 'add-certificador-form'];
        echo admin_form_open('certificadores/add', $attrib); 
        ?>

        <div class="modal-body">
            <p><?= lang('enter_info'); ?></p>

            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('nombre', 'nombre'); ?>
                        <?= form_input('nombre', '', 'class="form-control" id="nombre" required'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('descripcion', 'descripcion'); ?>
                        <?= form_input('descripcion', '', 'class="form-control" id="descripcion"'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('api_path', 'api_path'); ?>
                        <?= form_input('api_path', '', 'class="form-control" id="api_path" required'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('api_key', 'api_key'); ?>
                        <?= form_input('api_key', '', 'class="form-control" id="api_key"'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('activo', 'activo'); ?>
                        <?= form_dropdown('activo', ['1' => 'Sí', '0' => 'No'], '1', 'class="form-control" id="activo"'); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="btn btn-primary"><?= lang('agregar_certificador'); ?></button>
            <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
        </div>

        <?= form_close(); ?>
    </div>
</div>

<script>
$(document).ready(function () {
    $('#add-certificador-form').bootstrapValidator({
        feedbackIcons: {
            valid: 'fa fa-check',
            invalid: 'fa fa-times',
            validating: 'fa fa-refresh'

        }
    });
});
</script>
