<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificadores_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    // Agregar un nuevo certificador
    public function addCertificador($data)
    {
        return $this->db->insert('sma_certificadores', $data);
    }

    // Actualizar un certificador existente
    public function updateCertificador($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('sma_certificadores', $data);
    }

    // Eliminar un certificador
    public function deleteCertificador($id)
    {
        return $this->db->delete('sma_certificadores', ['id' => $id]);
    }

    // Obtener un certificador por ID
    public function getCertificadorByID($id)
    {
        $q = $this->db->get_where('sma_certificadores', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    // Obtener todos los certificadores
    public function getAllCertificadores()
    {
        $q = $this->db->get('sma_certificadores');
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return false;
    }

    // Sugerencias de certificadores (autocomplete)
    public function getCertificadorSuggestions($term, $limit = 10)
    {
        $this->db->select('id, nombre as text');
        $this->db->like('nombre', $term);
        $q = $this->db->get('sma_certificadores', $limit);
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return false;
    }
} // <- Esta es la llave final de la clase
