<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Bonificacion_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

    public function addBonificacion($data) {
        if ($this->db->insert('sma_bonificaciones', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    public function updateBonificacion($id, $data) {
        return $this->db->update('sma_bonificaciones', $data, ['id' => $id]);
    }

    public function deleteBonificacion($id) {
        return $this->db->delete('sma_bonificaciones', ['id' => $id]);
    }

    public function getBonificacionByID($id) {
        $q = $this->db->get_where('sma_bonificaciones', ['id' => $id], 1);
        if ($q->num_rows() > 0) {
            return $q->row();
        }
        return false;
    }

    public function getAllBonificaciones() {
        $q = $this->db->get('sma_bonificaciones');
        if ($q->num_rows() > 0) {
            return $q->result();
        }
        return false;
    }
}
