<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Ruta extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/Ruta_model');
        // No cargamos Companies_model ni Users_model
    }

    public function index() {
        // Obtenemos usuarios directamente
        $users = $this->db->get('sma_users')->result();

        // Obtenemos billers directamente de la tabla
        $billers = $this->db->get('sma_companies')->result();

        // Obtenemos warehouses si los necesitas
        $warehouses = $this->db->get('sma_warehouses')->result();

        $data = [
            'users' => $users,
            'billers' => $billers,
            'warehouses' => $warehouses,
        ];

        $this->load->view('ruta/index', $data);
    }

    public function getRutaReport() {
        $start_date = $this->input->post('start_date');
        $end_date   = $this->input->post('end_date');
        $user_ids   = $this->input->post('user'); // puede ser array de usuarios

        $report = $this->Ruta_model->getRutaConsolidado($start_date, $end_date, $user_ids);

        echo json_encode($report);
    }
}
