<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Clientes_certificador extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('clientes_certificador', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('clientes_certificador_model'); // Modelo cargado correctamente
    }

    public function index()
    {
        $this->sma->checkPermissions();

        $this->data['conexiones'] = $this->clientes_certificador_model->getAllConexiones();

        $bc = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('clientes_certificador')]];
        $meta = ['page_title' => lang('clientes_certificador'), 'bc' => $bc];
        $this->page_construct('clientes_certificador/index', $meta, $this->data);
    }

public function add()
{
    $this->sma->checkPermissions();

    if ($this->input->post()) {

        $this->form_validation->set_rules('certificador_id', 'Certificador', 'required');
        $this->form_validation->set_rules('sucursal_id', 'Sucursal', 'required');
        $this->form_validation->set_rules('nit', 'NIT', 'required');
        $this->form_validation->set_rules('usuario', 'Usuario', 'required');
        $this->form_validation->set_rules('contrasena', 'Contraseña', 'required');

        if ($this->form_validation->run() == true) {
            $data = [
                'certificador_id' => $this->input->post('certificador_id'),
                'sucursal_id'    => $this->input->post('sucursal_id'),
                'nit'            => $this->input->post('nit'),
                'usuario'        => $this->input->post('usuario'),
                'contrasena'     => $this->input->post('contrasena'),
                'activo'         => $this->input->post('activo'),
            ];

            $this->db->insert('sma_clientes_certificador_conexion', $data);

            $this->output
                 ->set_content_type('application/json')
                 ->set_output(json_encode(['status' => 'success', 'msg' => 'Conexión registrada']));
            exit;
        } else {
            $this->output
                 ->set_content_type('application/json')
                 ->set_output(json_encode(['status' => 'error', 'msg' => validation_errors()]));
            exit;
        }
    }

    // Solo carga la vista para abrir modal
    $data['certificadores'] = $this->db->get('sma_certificadores')->result();
    $data['sucursales'] = $this->db->get('sma_warehouses')->result();
    $this->load->view($this->theme . 'clientes_certificador/add', $data);
}


    public function edit($id)
{
    $this->sma->checkPermissions();

    $data['conexion'] = $this->db->get_where('sma_clientes_certificador_conexion', ['id' => $id])->row();
    $data['certificadores'] = $this->db->get('sma_certificadores')->result();
    $data['sucursales'] = $this->db->get('sma_warehouses')->result();

    $this->load->view($this->theme . 'clientes_certificador/add', $data);
}


    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->clientes_certificador_model->deleteConexion($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('conexion_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('conexion_x_deleted_have_related_data')]);
        }
    }
public function getConexiones()
{
    $this->sma->checkPermissions('index');
    $this->load->library('datatables');

    $this->datatables
        ->select("
            id, 
            (SELECT name FROM sma_warehouses w WHERE w.id = sma_clientes_certificador_conexion.sucursal_id) AS sucursal,
            (SELECT nombre FROM sma_certificadores f WHERE f.id = sma_clientes_certificador_conexion.certificador_id) AS certificador,
            nit, usuario, contrasena, activo
        ")
        ->from('sma_clientes_certificador_conexion')
        ->add_column('Actions', "<div class=\"text-center\">
            <a class=\"tip\" title='" . $this->lang->line('edit_conexion') . "' href='" . admin_url('clientes_certificador/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a>
            <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_conexion') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p>
            <a class='btn btn-danger po-delete' href='" . admin_url('clientes_certificador/delete/$1') . "'>" . lang('i_m_sure') . "</a>
            <button class='btn po-close'>" . lang('no') . "</button>\" rel='popover'><i class=\"fa fa-trash-o\"></i></a>
        </div>", 'id');

    echo $this->datatables->generate();
}





}
