<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificadores extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('clientes_certificador', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('certificadores_model'); // Modelo cargado correctamente
    }

    public function index()
    {
        $this->sma->checkPermissions();

        $this->data['certificadores'] = $this->certificadores_model->getAllCertificadores();

        

        $bc = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('certificadores')]];
        $meta = ['page_title' => lang('certificadores'), 'bc' => $bc];
        $this->page_construct('certificadores/index', $meta, $this->data);
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->method() === 'post') {
            $data = [
                'nombre'      => $this->input->post('nombre'),
                'descripcion' => $this->input->post('descripcion'),
                'api_path'    => $this->input->post('api_path'),
                'api_key'     => $this->input->post('api_key'),
                'activo'      => $this->input->post('activo') ? 1 : 0
            ];

            if ($this->certificadores_model->addCertificador($data)) {
                $this->session->set_flashdata('message', $this->lang->line('certificador_added'));
                redirect('admin/certificadores'); // Redirige a la lista de certificadores
            } else {
                $this->session->set_flashdata('error', 'Error al agregar certificador');
                redirect('admin/certificadores/add'); // Redirige al formulario de nuevo
            }
        }

        // Cargar la vista del formulario (modal o página)
        $this->load->view($this->theme . 'certificadores/add', $this->data);
    }

    public function edit($id = null)
    {
        $this->sma->checkPermissions(false, true);

        $certificador_details = $this->certificadores_model->getCertificadorByID($id);
        if (!$certificador_details) {
            $this->session->set_flashdata('error', lang('certificador_not_found'));
            redirect('admin/certificadores');
        }

        if ($this->input->method() === 'post') {
            $data = [
                'nombre'      => $this->input->post('nombre'),
                'descripcion' => $this->input->post('descripcion'),
                'api_path'    => $this->input->post('api_path'),
                'api_key'     => $this->input->post('api_key'),
                'activo'      => $this->input->post('activo') ? 1 : 0
            ];

            if ($this->certificadores_model->updateCertificador($id, $data)) {
                $this->session->set_flashdata('message', $this->lang->line('certificador_updated'));
                redirect('admin/certificadores');
            } else {
                $this->session->set_flashdata('error', 'Error al actualizar certificador');
                redirect('admin/certificadores/edit/' . $id);
            }
        }

        $this->data['certificador'] = $certificador_details;
        $this->load->view($this->theme . 'certificadores/edit', $this->data);
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->certificadores_model->deleteCertificador($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('certificador_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('certificador_x_deleted_have_related_data')]);
        }
    }

    public function getCertificadores()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, nombre, descripcion, api_path, api_key, activo')
            ->from('sma_certificadores')
            ->add_column('Actions', "<div class=\"text-center\">
                <a class=\"tip\" title='" . $this->lang->line('edit_certificador') . "' href='" . admin_url('certificadores/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> 
                <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_certificador') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('certificadores/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\" rel='popover'><i class=\"fa fa-trash-o\"></i></a>
            </div>", 'id');

        echo $this->datatables->generate();
    }

    public function certificador_actions()
    {
        if (!$this->Owner && !$this->GP['bulk_actions']) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            redirect($_SERVER['HTTP_REFERER']);
        }

        $this->form_validation->set_rules('form_action', lang('form_action'), 'required');

        if ($this->form_validation->run() == true) {
            if (!empty($_POST['val'])) {
                if ($this->input->post('form_action') == 'delete') {
                    $this->sma->checkPermissions('delete');
                    $error = false;
                    foreach ($_POST['val'] as $id) {
                        if (!$this->certificadores_model->deleteCertificador($id)) {
                            $error = true;
                        }
                    }
                    if ($error) {
                        $this->session->set_flashdata('warning', lang('certificadores_x_deleted_have_related_data'));
                    } else {
                        $this->session->set_flashdata('message', $this->lang->line('certificadores_deleted'));
                    }
                    redirect($_SERVER['HTTP_REFERER']);
                }
            } else {
                $this->session->set_flashdata('error', $this->lang->line('no_certificador_selected'));
                redirect($_SERVER['HTTP_REFERER']);
            }
        } else {
            $this->session->set_flashdata('error', validation_errors());
            redirect($_SERVER['HTTP_REFERER']);
        }
    }
}
