<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Bonificacion extends MY_Controller
{
     public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('bonificacion', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('bonificacion_model'); // Modelo cargado correctamente
    }

    public function index()
    {
        $this->sma->checkPermissions();

        $this->data['bonificacion'] = $this->bonificacion_model->getAllBonificaciones();

        

        $bc = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('bonificaciones')]];
        $meta = ['page_title' => lang('Bonificaciones'), 'bc' => $bc];
        $this->page_construct('bonificaciones/index', $meta, $this->data);
    }
    public function add()
    {
        $this->form_validation->set_rules('customer_id', 'Cliente', 'required');
        $this->form_validation->set_rules('product_id', 'Producto', 'required');
        $this->form_validation->set_rules('quantity', 'Cantidad', 'required|numeric');

        if ($this->form_validation->run() == true) {
            $data = [
                'reference_no' => $this->input->post('reference_no'),
                'customer_id'  => $this->input->post('customer_id'),
                'product_id'   => $this->input->post('product_id'),
                'quantity'     => $this->input->post('quantity'),
                'cost'         => $this->input->post('cost'),
                'status'       => $this->input->post('status') ?? 'completo',
                'note'         => $this->input->post('note'),
                'user_created' => $this->session->userdata('user_id'),
            ];

            if ($this->bonificacion_model->add($data)) {
                $this->session->set_flashdata('message', 'Bonificación registrada correctamente.');
                redirect('bonificacion');
            } else {
                $this->session->set_flashdata('error', 'Error al registrar la bonificación.');
                redirect('bonificacion/add');
            }
        } else {
            $this->data['products']  = $this->bonificacion_model->getProducts();
            $this->data['customers'] = $this->bonificacion_model->getCustomers();
            $this->load->view($this->theme . 'bonificacion/add', $this->data);
        }
    }

    public function edit($id = null)
    {
        $this->form_validation->set_rules('status', 'Estado', 'required');

        if ($this->form_validation->run() == true) {
            $data = [
                'status'       => $this->input->post('status'),
                'note'         => $this->input->post('note'),
                'user_updated' => $this->session->userdata('user_id'),
            ];

            if ($this->bonificacion_model->update($id, $data)) {
                $this->session->set_flashdata('message', 'Bonificación actualizada correctamente.');
                redirect('bonificacion');
            } else {
                $this->session->set_flashdata('error', 'Error al actualizar la bonificación.');
                redirect('bonificacion/edit/' . $id);
            }
        } else {
            $this->data['bonificacion'] = $this->bonificacion_model->getById($id);
            $this->load->view($this->theme . 'bonificacion/edit', $this->data);
        }
    }

    public function delete($id = null)
    {
        if ($id && $this->bonificacion_model->delete($id)) {
            $this->session->set_flashdata('message', 'Bonificación eliminada.');
        } else {
            $this->session->set_flashdata('error', 'No se pudo eliminar la bonificación.');
        }
        redirect('bonificacion');
    }
public function getBonificacion()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select('id, created_at, reference_no, customer_id, product_id, quantity, cost, status')
            ->from('sma_bonificaciones')
            ->add_column('Actions', "<div class=\"text-center\">
                <a class=\"tip\" title='" . $this->lang->line('edit_bonificacion') . "' href='" . admin_url('bonificacion/edit/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a> 
                <a href='#' class='tip po' title='<b>" . $this->lang->line('delete_bonificacion') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('bonificacion/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\" rel='popover'><i class=\"fa fa-trash-o\"></i></a>
            </div>", 'id');

        echo $this->datatables->generate();
    }
}
