<div class="box">
    <div class="box-header">
        <h2 class="blue"><i class="fa fa-list"></i><?= lang('Lista de Certificadores'); ?></h2>
    </div>
    <div class="box-content">
        <?php if (!empty($error)): ?>
            <div class="alert alert-warning"><?= $error; ?></div>
        <?php endif; ?>

        <?php if (!empty($certificadores)): ?>
            <table class="table table-bordered table-striped">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Nombre</th>
                        <th>Descripción</th>
                        <th>API Path</th>
                        <th>API Key</th>
                        <th>Activo</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($certificadores as $c): ?>
                        <tr>
                            <td><?= $c->id; ?></td>
                            <td><?= $c->nombre; ?></td>
                            <td><?= $c->descripcion; ?></td>
                            <td><?= $c->api_path; ?></td>
                            <td><?= $c->api_key; ?></td>
                            <td><?= $c->activo ? 'Sí' : 'No'; ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <p>No hay certificadores disponibles.</p>
        <?php endif; ?>
    </div>
</div>
