<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class ConexionCertificadorTest extends CI_Controller {

    public function __construct() {
        parent::__construct();
        $this->load->model('admin/ConexionCertificadorTest_model');
    }

    // Obtener token
    public function token($sucursal_id) {
        $conexion = $this->ConexionCertificadorTest_model->getConexion($sucursal_id);
        if (!$conexion) {
            echo json_encode(['status' => 'error', 'msg' => 'No existe conexión para la sucursal']);
            return;
        }

        $usuario = $conexion->usuario;
        $nit = $conexion->nit;

        $token = $this->ConexionCertificadorTest_model->getToken($conexion->id, $usuario, $nit);

        if ($token) {
            echo json_encode(['status' => 'ok', 'id' => $conexion->id, 'token' => $token]);
        } else {
            echo json_encode(['status' => 'error', 'msg' => 'No se pudo generar token']);
        }
    }

    // Probar conexión SAT
    public function prueba($sucursal_id) {
        $conexion = $this->ConexionCertificadorTest_model->getConexion($sucursal_id);
        if (!$conexion) {
            echo json_encode(['status' => 'error', 'msg' => 'No existe conexión para la sucursal']);
            return;
        }

        $token = $this->ConexionCertificadorTest_model->getToken($conexion->id, $conexion->usuario, $conexion->nit);

        if (!$token) {
            echo json_encode(['status' => 'error', 'msg' => 'No se pudo generar token']);
            return;
        }

        $resultado = $this->ConexionCertificadorTest_model->pruebaSAT($token);
        echo json_encode($resultado);
    }
}
