<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Clientes_certificador extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->loggedIn) {
            $this->session->set_userdata('requested_page', $this->uri->uri_string());
            $this->sma->md('login');
        }

        $this->lang->admin_load('clientes_certificador', $this->Settings->user_language);
        $this->load->library('form_validation');
        $this->load->admin_model('clientes_certificador_model');
    }

    public function index()
    {
        $this->sma->checkPermissions();

        $bc = [['link' => base_url(), 'page' => lang('home')], ['link' => '#', 'page' => lang('clientes_certificador')]];
        $meta = ['page_title' => lang('clientes_certificador'), 'bc' => $bc];
        $this->page_construct('clientes_certificador/index', $meta);
    }

    public function add()
    {
        $this->sma->checkPermissions(false, true);

        if ($this->input->method() === 'post') {
            $data = [
                'certificador_id' => $this->input->post('certificador_id'),
                'sucursal_id'    => $this->input->post('sucursal_id'),
                'nit'            => $this->input->post('nit'),
                'usuario'        => $this->input->post('usuario'),
                'contrasena'     => $this->input->post('contrasena'),
                'activo'         => $this->input->post('activo') ? 1 : 0,
                'fecha_creacion' => date('Y-m-d H:i:s')
            ];

            if ($this->clientes_certificador_model->addCliente($data)) {
                $this->session->set_flashdata('message', lang('cliente_added'));
                redirect('admin/clientes_certificador');
            } else {
                $this->session->set_flashdata('error', 'Error al agregar cliente');
                redirect('admin/clientes_certificador/add');
            }
        }

        $this->data['certificadores'] = $this->clientes_certificador_model->getAllCertificadores();
        $this->data['sucursales'] = $this->clientes_certificador_model->getAllSucursales();
        $this->load->view($this->theme . 'clientes_certificador/add', $this->data);
    }

    public function editar($id = null)
    {
        $this->sma->checkPermissions(false, true);

        $cliente = $this->clientes_certificador_model->getClienteByID($id);
        if (!$cliente) {
            $this->session->set_flashdata('error', lang('cliente_not_found'));
            redirect('admin/clientes_certificador');
        }

        if ($this->input->method() === 'post') {
            $data = [
                'certificador_id' => $this->input->post('certificador_id'),
                'sucursal_id'    => $this->input->post('sucursal_id'),
                'nit'            => $this->input->post('nit'),
                'usuario'        => $this->input->post('usuario'),
                'contrasena'     => $this->input->post('contrasena'),
                'activo'         => $this->input->post('activo') ? 1 : 0,
            ];

            if ($this->clientes_certificador_model->updateCliente($id, $data)) {
                $this->session->set_flashdata('message', lang('cliente_updated'));
                redirect('admin/clientes_certificador');
            } else {
                $this->session->set_flashdata('error', lang('error_update_cliente'));
                redirect('admin/clientes_certificador/editar/'.$id);
            }
        }

        $this->data['cliente'] = $cliente;
        $this->data['certificadores'] = $this->clientes_certificador_model->getAllCertificadores();
        $this->data['sucursales'] = $this->clientes_certificador_model->getAllSucursales();
        $this->load->view($this->theme.'clientes_certificador/edit', $this->data);
    }

    public function delete($id = null)
    {
        $this->sma->checkPermissions(null, true);

        if ($this->clientes_certificador_model->deleteCliente($id)) {
            $this->sma->send_json(['error' => 0, 'msg' => lang('cliente_deleted')]);
        } else {
            $this->sma->send_json(['error' => 1, 'msg' => lang('cliente_x_deleted_have_related_data')]);
        }
    }

    public function getClientes()
    {
        $this->sma->checkPermissions('index');

        $this->load->library('datatables');
        $this->datatables
            ->select("cc.id, c.nombre as certificador, w.name as sucursal, cc.nit, cc.usuario, cc.activo, cc.fecha_creacion")
            ->from("sma_clientes_certificador_conexion cc")
            ->join("sma_certificadores c", "cc.certificador_id=c.id", "left")
            ->join("sma_warehouses w", "cc.sucursal_id=w.id", "left")
            ->add_column('Actions', "<div class=\"text-center\">
                <a class=\"tip\" title='" . lang('edit') . "' href='" . admin_url('clientes_certificador/editar/$1') . "' data-toggle='modal' data-target='#myModal'><i class=\"fa fa-edit\"></i></a>
                <a href='#' class='tip po' title='<b>" . lang('delete') . "</b>' data-content=\"<p>" . lang('r_u_sure') . "</p><a class='btn btn-danger po-delete' href='" . admin_url('clientes_certificador/delete/$1') . "'>" . lang('i_m_sure') . "</a> <button class='btn po-close'>" . lang('no') . "</button>\" rel='popover'><i class=\"fa fa-trash-o\"></i></a>
            </div>", 'id');

        echo $this->datatables->generate();
    }
}
