<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title"><?= lang('edit_conexion'); ?></h4>
        </div>

        <?php
        $attrib = ['data-toggle' => 'validator', 'role' => 'form', 'id' => 'edit-conexion-form'];
        echo admin_form_open('clientes_certificador/edit/'.$conexion->id, $attrib);
        ?>

        <div class="modal-body">
            <?php if($error) echo '<div class="alert alert-danger">'.$error.'</div>'; ?>
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <?= lang('certificador', 'certificador_id'); ?>
                        <select name="certificador_id" class="form-control" id="certificador_id" required>
                            <option value=""><?= lang('select_certificador'); ?></option>
                            <?php foreach ($certificadores as $cert): ?>
                                <option value="<?= $cert->id; ?>" <?= $conexion->certificador_id == $cert->id ? 'selected' : ''; ?>><?= $cert->nombre; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <?= lang('sucursal', 'sucursal_id'); ?>
                        <select name="sucursal_id" class="form-control" id="sucursal_id" required>
                            <option value=""><?= lang('select_sucursal'); ?></option>
                            <?php foreach ($sucursales as $sucursal): ?>
                                <option value="<?= $sucursal->id; ?>" <?= $conexion->sucursal_id == $sucursal->id ? 'selected' : ''; ?>><?= $sucursal->name; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="form-group">
                        <?= lang('nit', 'nit'); ?>
                        <?= form_input('nit', $conexion->nit, 'class="form-control" id="nit"'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('usuario', 'usuario'); ?>
                        <?= form_input('usuario', $conexion->usuario, 'class="form-control" id="usuario"'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('contrasena', 'contrasena'); ?>
                        <?= form_password('contrasena', $conexion->contrasena, 'class="form-control" id="contrasena"'); ?>
                    </div>

                    <div class="form-group">
                        <?= lang('activo', 'activo'); ?>
                        <?= form_dropdown('activo', ['1' => 'Sí', '0' => 'No'], $conexion->activo, 'class="form-control" id="activo"'); ?>
                    </div>
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button type="submit" class="btn btn-primary"><?= lang('guardar_conexion'); ?></button>
            <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
        </div>
        <?= form_close(); ?>
    </div>
</div>
