<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<div class="modal-dialog modal-lg">
    <div class="modal-content">
        <div class="modal-header">
            <button type="button" class="close" data-dismiss="modal">
                <i class="fa fa-2x">&times;</i>
            </button>
            <h4 class="modal-title"><?= isset($conexion) ? lang('edit_conexion') : lang('add_conexion'); ?></h4>
        </div>

        <?php
        // Eliminamos cualquier atributo que genere conflicto (validator, autocomplete)
        $attrib = ['role' => 'form', 'id' => 'add-conexion-form', 'autocomplete' => 'off'];
        echo admin_form_open('clientes_certificador/' . (isset($conexion) ? 'edit/' . $conexion->id : 'add'), $attrib);
        ?>

        <div class="modal-body">
            <div id="form-alerts"></div>

            <p><?= lang('enter_info'); ?></p>
            <div class="row">
                <div class="col-md-6">

                    <!-- Certificador -->
                    <div class="form-group">
                        <?= lang('certificador', 'certificador_id'); ?>
                        <select name="certificador_id" class="form-control" id="certificador_id" required>
                            <option value=""><?= lang('select_certificador'); ?></option>
                            <?php foreach ($certificadores as $cert): ?>
                                <option value="<?= $cert->id; ?>" <?= isset($conexion) && $conexion->certificador_id == $cert->id ? 'selected' : ''; ?>>
                                    <?= $cert->nombre; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- Sucursal -->
                    <div class="form-group">
                        <?= lang('sucursal', 'sucursal_id'); ?>
                        <select name="sucursal_id" class="form-control" id="sucursal_id" required>
                            <option value=""><?= lang('select_sucursal'); ?></option>
                            <?php foreach ($sucursales as $sucursal): ?>
                                <option value="<?= $sucursal->id; ?>" <?= isset($conexion) && $conexion->sucursal_id == $sucursal->id ? 'selected' : ''; ?>>
                                    <?= $sucursal->name; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <!-- NIT -->
                    <div class="form-group">
                        <?= lang('nit', 'nit'); ?>
                        <?= form_input('nit', isset($conexion) ? $conexion->nit : '', 'class="form-control" id="nit" required'); ?>
                    </div>

                    <!-- Usuario -->
                    <div class="form-group">
                        <?= lang('usuario', 'usuario'); ?>
                        <?= form_input('usuario', isset($conexion) ? $conexion->usuario : '', 'class="form-control" id="usuario" required'); ?>
                    </div>

                    <!-- Contraseña -->
                    <div class="form-group">
                        <?= lang('contrasena', 'contrasena'); ?>
                        <?= form_password('contrasena', isset($conexion) ? $conexion->contrasena : '', 'class="form-control" id="contrasena" required'); ?>
                    </div>

                    <!-- Activo -->
                    <div class="form-group">
                        <?= lang('activo', 'activo'); ?>
                        <?= form_dropdown('activo', ['1' => 'Sí', '0' => 'No'], isset($conexion) ? $conexion->activo : '1', 'class="form-control" id="activo"'); ?>
                    </div>

                </div>
            </div>
        </div>

        <div class="modal-footer">
            <!-- Botón tipo button, nunca submit -->
            <button type="button" id="btn-save-conexion" class="btn btn-primary"><?= isset($conexion) ? lang('update_conexion') : lang('guardar_conexion'); ?></button>
            <button type="button" class="btn btn-default" data-dismiss="modal"><?= lang('close'); ?></button>
        </div>

        <?= form_close(); ?>
    </div>
</div>


<script>
$(document).ready(function() {

    $('#btn-save-conexion').off('click').on('click', function() {
        var $form = $('#add-conexion-form');

        // Limpiar alertas
        $('#form-alerts').html('');

        $.ajax({
            url: $form.attr('action'),
            type: 'POST',
            data: $form.serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.status === 'success') {
                    $('#myModal').modal('hide');  // cierra modal
                    toastr.success(response.msg); // mensaje éxito
                    if (typeof oTable !== 'undefined') {
                        oTable.ajax.reload(null, false); // refresca DataTable
                    }
                } else {
                    $('#form-alerts').html('<div class="alert alert-danger">' + response.msg + '</div>');
                }
            },
            error: function(xhr, status, error) {
                console.log(xhr.responseText);
                $('#form-alerts').html('<div class="alert alert-danger">Error al procesar la solicitud</div>');
            }
        });
    });

});
</script>



</div>
