<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<script>
    $(document).ready(function () {
        oTable = $('#SLData').dataTable({
            "aaSorting": [[1, "desc"], [2, "desc"]],
            "aLengthMenu": [[10, 25, 50, 100, -1], [10, 25, 50, 100, "<?=lang('all')?>"]],
            "iDisplayLength": <?=$Settings->rows_per_page?>,
            'bProcessing': true, 'bServerSide': true,
            'sAjaxSource': '<?=admin_url('sales/getSales' . ($warehouse_id ? '/' . $warehouse_id : '') . '?v=1' . ($this->input->get('shop') ? '&shop=' . $this->input->get('shop') : '') . ($this->input->get('attachment') ? '&attachment=' . $this->input->get('attachment') : '') . ($this->input->get('delivery') ? '&delivery=' . $this->input->get('delivery') : '')); ?>',
            'fnServerData': function (sSource, aoData, fnCallback) {
                aoData.push({
                    "name": "<?=$this->security->get_csrf_token_name()?>",
                    "value": "<?=$this->security->get_csrf_hash()?>"
                });
                $.ajax({'dataType': 'json', 'type': 'POST', 'url': sSource, 'data': aoData, 'success': fnCallback});
            },
            'fnRowCallback': function (nRow, aData, iDisplayIndex) {
                var oSettings = oTable.fnSettings();
                //$("td:first", nRow).html(oSettings._iDisplayStart+iDisplayIndex +1);
                nRow.id = aData[0];
                nRow.setAttribute('data-return-id', aData[11]);
                nRow.className = "invoice_link re"+aData[11];
                //if(aData[7] > aData[9]){ nRow.className = "product_link warning"; } else { nRow.className = "product_link"; }
                return nRow;
            },
            "aoColumns": [{"bSortable": false,"mRender": checkbox}, {"mRender": fld}, null, null, null, {"mRender": row_status}, {"mRender": currencyFormat}, {"mRender": currencyFormat}, {"mRender": currencyFormat}, {"mRender": pay_status}, {"bSortable": false,"mRender": attachment}, {"bVisible": false}, {"bSortable": false}],
            "fnFooterCallback": function (nRow, aaData, iStart, iEnd, aiDisplay) {
                var gtotal = 0, paid = 0, balance = 0;
                for (var i = 0; i < aaData.length; i++) {
                    gtotal += parseFloat(aaData[aiDisplay[i]][6]);
                    paid += parseFloat(aaData[aiDisplay[i]][7]);
                    balance += parseFloat(formatDecimals(aaData[aiDisplay[i]][8]));
                }
                var nCells = nRow.getElementsByTagName('th');
                nCells[6].innerHTML = currencyFormat(parseFloat(gtotal));
                nCells[7].innerHTML = currencyFormat(parseFloat(paid));
                nCells[8].innerHTML = currencyFormat(parseFloat(balance));
            }
        }).fnSetFilteringDelay().dtFilter([
            {column_number: 1, filter_default_label: "[<?=lang('date');?> (yyyy-mm-dd)]", filter_type: "text", data: []},
            {column_number: 2, filter_default_label: "[<?=lang('reference_no');?>]", filter_type: "text", data: []},
            {column_number: 3, filter_default_label: "[<?=lang('biller');?>]", filter_type: "text", data: []},
            {column_number: 4, filter_default_label: "[<?=lang('customer');?>]", filter_type: "text", data: []},
            {column_number: 5, filter_default_label: "[<?=lang('sale_status');?>]", filter_type: "text", data: []},
            {column_number: 9, filter_default_label: "[<?=lang('payment_status');?>]", filter_type: "text", data: []},
        ], "footer");
// ======= AGREGAR BOTÓN RUTA Y FACTURAR EN LA TABLA =======
$('#SLData').on('draw.dt', function () {
    $('#SLData tbody tr').each(function () {
        var tdAcciones = $(this).find('td').last(); // Última columna (acciones)
        var venta_id = $(this).attr('id'); // id de la fila = id de la venta

        // Botón Ruta
        if (!tdAcciones.find('.btn-ruta').length) {
            tdAcciones.append(' <button class="btn btn-xs btn-success btn-ruta" data-venta-id="'+venta_id+'"><i class="fa fa-map-marker"></i> Ruta</button>');
        }

        // Botón Facturar
        if (!tdAcciones.find('.btn-facturar').length) {
            tdAcciones.append(' <button class="btn btn-xs btn-primary btn-facturar" data-venta-id="'+venta_id+'"><i class="fa fa-file-text"></i> Facturar</button>');
        }
    });
});
// ======= MOSTRAR RUTA EN EL MODAL =======
$(document).on('click', '.btn-ruta', function () {
    var venta_id = $(this).data('venta-id');
    $('#modalRuta').modal('show');
    $('#mapRuta').html('');
    $('#instruccionesRuta').html('Cargando ruta...');

    $.ajax({
        url: '<?=base_url('ruta/cliente/')?>' + venta_id, // Debes crear este controlador
        type: 'GET',
        dataType: 'json',
        success: function (data) {
            if(!data.lat || !data.lng){
                alert('Este cliente no tiene coordenadas.');
                return;
            }

            var destino = [data.lat, data.lng];
            var map = L.map('mapRuta').fitWorld();
            L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
                attribution: '&copy; OpenStreetMap contributors'
            }).addTo(map);

            map.locate({setView: true, maxZoom: 16});
            map.on('locationfound', function(e){
                var origen = [e.latitude, e.longitude];
                L.marker(origen).addTo(map).bindPopup("Tu ubicación").openPopup();
                L.marker(destino).addTo(map).bindPopup("Destino: "+data.nombre);

                L.Routing.control({
                    waypoints: [
                        L.latLng(origen[0], origen[1]),
                        L.latLng(destino[0], destino[1])
                    ],
                    routeWhileDragging: false
                }).addTo(map);
            });

            map.on('locationerror', function(){
                alert("No se pudo obtener tu ubicación. Activa el GPS.");
            });
        },
        error: function(){
            alert('No se pudieron obtener los datos del cliente.');
        }
    });
});

// ======= MOSTRAR MODAL FACTURAR =======
$(document).on('click', '.btn-facturar', function () {
    var venta_id = $(this).data('venta-id');
    $('#venta_id_facturar').val(venta_id);
    $('#nit').val('');
    $('#facturaResponse').html('');
    $('#modalFacturar').modal('show');
});

// ======= GENERAR FACTURA (AJAX) =======
$('#btnGenerarFactura').click(function () {
    var formData = $('#formFacturar').serialize();

    $.post('<?=admin_url("factura/generar")?>', formData, function (response) {
        if (response.success) {
            $('#facturaResponse').html('<div class="alert alert-success">'+response.message+'</div>');
            setTimeout(function(){
                $('#modalFacturar').modal('hide');
                $('#SLData').DataTable().ajax.reload();
            }, 2000);
        } else {
            $('#facturaResponse').html('<div class="alert alert-danger">'+response.message+'</div>');
        }
    }, 'json');
});

        if (localStorage.getItem('remove_slls')) {
            ...
        }

        <?php if ($this->session->userdata('remove_slls')) { ?>
            ...
        <?php $this->sma->unset_data('remove_slls'); } ?>

        $(document).on('click', '.sledit', function (e) {
            ...
        });
        $(document).on('click', '.slduplicate', function (e) {
            ...
        });

    });

</script>

<?php if ($Owner || $GP['bulk_actions']) {
            echo admin_form_open('sales/sale_actions', 'id="action-form"');
        }
?>
<div class="box">
    <div class="box-header">
        <h2 class="blue"><i
                class="fa-fw fa fa-heart"></i><?=lang('sales') . ' (' . ($warehouse_id ? $warehouse->name : lang('all_warehouses')) . ')';?>
        </h2>

        <div class="box-icon">
            ...
        </div>
    </div>
    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">

                <p class="introtext"><?=lang('list_results');?></p>

                <div class="table-responsive">
                    <table id="SLData" class="table table-bordered table-hover table-striped" cellpadding="0" cellspacing="0" border="0">
                        <thead> ... </thead>
                        <tbody>
                        <tr>
                            <td colspan="12" class="dataTables_empty"><?= lang('loading_data'); ?></td>
                        </tr>
                        <!-- Modal para Ruta -->
<div class="modal fade" id="modalRuta" tabindex="-1" role="dialog" aria-labelledby="modalRutaLabel" aria-hidden="true">
  ...
</div>

<!-- Modal para Facturar -->
<div class="modal fade" id="modalFacturar" tabindex="-1" role="dialog" aria-labelledby="modalFacturarLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalFacturarLabel">Generar Factura</h5>
        <button type="button" class="close" data-dismiss="modal">&times;</button>
      </div>
      <div class="modal-body">
        <form id="formFacturar">
          <input type="hidden" name="venta_id" id="venta_id_facturar">
          <div class="form-group">
            <label for="nit">NIT</label>
            <input type="text" class="form-control" name="nit" id="nit" required>
          </div>
        </form>
        <div id="facturaResponse"></div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-primary" id="btnGenerarFactura">Generar Factura</button>
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Cerrar</button>
      </div>
    </div>
  </div>
</div>

<!-- Librerías de Leaflet -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>
<script src="https://unpkg.com/leaflet-routing-machine@3.2.12/dist/leaflet-routing-machine.min.js"></script>
<link rel="stylesheet" href="https://unpkg.com/leaflet-routing-machine@3.2.12/dist/leaflet-routing-machine.css"/>

                        </tbody>
                        <tfoot class="dtFilter"> ... </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php if ($Owner || $GP['bulk_actions']) { ?>
    <div style="display: none;">
        <input type="hidden" name="form_action" value="" id="form_action"/>
        <?=form_submit('performAction', 'performAction', 'id="action-form-submit"')?>
    </div>
    <?=form_close()?>
<?php } ?>
