<?php
$reference_no = $_GET['reference_no'] ?? '';
?>

<!-- Modal FEL -->
<div class="modal fade" id="felModal" tabindex="-1" role="dialog" aria-labelledby="felModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Facturación Electrónica</h5>
      </div>
      <div class="modal-body">
        <div class="form-group">
            <label>NIT (dejar C/F si no tiene)</label>
            <input type="text" id="fel_nit" class="form-control" value="C/F">
        </div>
        <p>Referencia de ticket: <b><?= $reference_no ?></b></p>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" id="btnSoloTicket">Solo Ticket</button>
        <button type="button" class="btn btn-danger" id="btnFacturarFelModal">Facturar FEL</button>
      </div>
    </div>
  </div>
</div>

<script>
$(document).ready(function(){
    $('#felModal').modal({backdrop:'static', keyboard:false});
    $('#felModal').modal('show');

    // SOLO TICKET
    $('#btnSoloTicket').click(function(){
        // redirige de vuelta al POS y deja imprimir ticket
        window.location.href = "<?= admin_url('pos/view/').$reference_no ?>";
    });

    // FACTURAR FEL
    $('#btnFacturarFelModal').click(function(){
        let nit = $('#fel_nit').val() || 'C/F';

        $.ajax({
            url: "<?= admin_url('fel/emitir'); ?>",
            method: "POST",
            data: { sale_id: "<?= $reference_no ?>", nit: nit },
            dataType: "json",
            success: function(res){
                if(res.ok){
                    alert('Factura emitida correctamente!');
                    // redirigir a ticket ya facturado
                    window.location.href = "<?= admin_url('pos/view/').$reference_no ?>";
                } else {
                    alert('Error al emitir la factura');
                }
            },
            error: function(){
                alert('Error de comunicación con el servidor');
            }
        });
    });
});
</script>
