<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<script>
$(document).ready(function () {
    var mTable = $('#MermaData').dataTable({
        "aaSorting": [[9, "desc"]],
        "aLengthMenu": [[10,25,50,100,-1],[10,25,50,100,"<?= lang('all') ?>"]],
        "iDisplayLength": <?= $Settings->rows_per_page ?>,
        'bProcessing': true, 'bServerSide': true,
        'sAjaxSource': '<?= admin_url('merma/getMerma') ?>',
        'fnServerData': function (sSource, aoData, fnCallback) {
            aoData.push({"name":"<?= $this->security->get_csrf_token_name() ?>","value":"<?= $this->security->get_csrf_hash() ?>"});
            aoData.push({"name":"status","value":$('#fstatus').val()});
            aoData.push({"name":"user","value":$('#fuser').val()});
            aoData.push({"name":"start_date","value":$('#fstart').val()});
            aoData.push({"name":"end_date","value":$('#fend').val()});
            $.ajax({'dataType':'json','type':'POST','url':sSource,'data':aoData,'success':fnCallback});
        },
        'fnRowCallback': function (nRow, aData) {
            nRow.id = aData[0];
            return nRow;
        },
        "aoColumns": [
            {"bSortable": false, "mRender": checkbox}, // checkbox
            null, // created_at
            
            null, // reference_no
            null, // customer_id
            null, // product name
            null, // quantity
            {"mRender": currencyFormat}, // cost
            
            null, // status
            null, // action
                        
            {"bSortable": false} // actions
        ]
    });

    // filtros
    $('#filterGo').on('click', function(){ mTable.fnDraw(false); });
    // refrescar al cerrar modal (add/retornar/desechar)
    $('#myModal, #myModal2').on('hidden.bs.modal', function(){ mTable.fnDraw(false); });

});
</script>

<div class="box">
  <div class="box-header">
    <h2 class="blue"><i class="fa fa-minus-circle"></i> <?= lang('Mermas') ?></h2>
    <div class="box-icon">
      <ul class="btn-tasks">
        <li>
          <a href="<?= admin_url('merma/add'); ?>" data-toggle="modal" data-target="#myModal" id="add_merma">
            <i class="fa fa-plus-circle"></i> <?= lang('new_merma') ?>
          </a>
        </li>
      </ul>
    </div>
  </div>

  <div class="box-content">
    <div class="row">
      <div class="col-lg-12">
        <p class="introtext"><?= lang('list_results'); ?></p>
        <div class="table-responsive">
          <table id="MermaData" class="table table-bordered table-condensed table-hover table-striped">
            <thead>
              <tr class="primary">
                <th style="width:50px;text-align:center;"><input class="checkbox checkth" type="checkbox" name="check"/></th>
		<th><?= lang('date') ?></th>
                
		<th><?= lang('reference_no') ?></th>
                <th><?= lang('customer_id') ?></th>
                <th><?= lang('product') ?></th>
                <th><?= lang('quantity') ?></th>
                <th><?= lang('cost') ?></th>
                <th><?= lang('status') ?></th>
                <th><?= lang('action') ?></th>
                
                <th style="width:110px;"><?= lang('actions') ?></th>
              </tr>
            </thead>
            <tbody><tr><td colspan="9" class="dataTables_empty"><?= lang('loading_data_from_server') ?></td></tr></tbody>
            <tfoot class="dtFilter"><tr class="active"><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th></th><th class="text-center"><?= lang('actions') ?></th></tr></tfoot>
          </table>
        </div>

      </div>
    </div>
  </div>
</div>
