<!-- ========================= -->
<!-- MODAL FACTURA FEL (COMPLETO) -->
<!-- ========================= -->

<div class="modal fade" id="modalFel" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">

            <div class="modal-header bg-primary text-white">
                <h4 class="modal-title">Factura Electrónica FEL</h4>
            </div>

            <div class="modal-body">

                <!-- NIT -->
                <div class="form-group">
                    <label>NIT</label>
                    <input type="text" id="fel_nit" class="form-control" placeholder="CF o NIT">
                </div>

                <!-- Nombre -->
                <div class="form-group">
                    <label>Nombre</label>
                    <input type="text" id="fel_nombre" class="form-control">
                </div>

                <!-- Dirección -->
                <div class="form-group">
                    <label>Dirección</label>
                    <input type="text" id="fel_direccion" class="form-control">
                </div>

                <!-- Preview -->
                <hr>
                <h5>Vista previa</h5>

                <div id="fel_preview" style="
                    background:#f8f9fa;
                    padding:15px;
                    border-radius:10px;
                    font-size:13px;
                    max-height:200px;
                    overflow:auto;
                ">
                    Sin datos aún...
                </div>

            </div>

            <div class="modal-footer">
                <button class="btn btn-secondary" data-dismiss="modal">Cancelar</button>
                <button id="btnEmitirFel" class="btn btn-success">Emitir FEL</button>
            </div>

        </div>
    </div>
</div>


<!-- ========================= -->
<!-- JS DEL MODAL (AQUI MISMO) -->
<!-- ========================= -->

<script>

$(function(){

    /* =========================
       PREVIEW
    ========================= */

    function renderPreview(){
        let nit = $("#fel_nit").val();
        $("#fel_preview").html("<b>NIT:</b> " + nit);
    }

    $("#fel_nit").on("keyup change", renderPreview);


    /* =========================
       EMITIR FEL
    ========================= */

    $("#btnEmitirFel").click(function(){

        let nit = $("#fel_nit").val();

        if(!nit){
            alert("Ingresa NIT");
            return;
        }

        /* 🔥 MUY IMPORTANTE
           sacar ticket actual
           (tu POS ya lo tiene en pantalla)
        */

        let ticket = $("#ticket_id").val() 
                     || $("#sale_id").val() 
                     || $(".ticket_id").val();

        $.ajax({
            url: "<?= base_url('fel/emitir') ?>",
            type: "POST",
            dataType: "json",
            data:{
                ticket: ticket,   // 👈 REQUIRED por tu controller
                nit: nit          // 👈 REQUIRED por tu controller
            },

            success:function(r){

                if(r.status){
                    alert("✅ FEL generado\nUUID: " + r.uuid);
                    location.reload();
                }else{
                    alert("❌ " + r.msg);
                }

            },

            error:function(){
                alert("Error servidor");
            }

        });

    });

});

</script>

});

</script>
