<div class="modal fade" id="modalConfirmacion" tabindex="-1" role="dialog" aria-labelledby="modalConfirmacionLabel">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Cerrar"><span aria-hidden="true">&times;</span></button>
                <h4 class="modal-title" id="modalConfirmacionLabel">Confirmación de Datos del Cliente</h4>
            </div>
            <div class="modal-body">
                <form id="formConfirmacion">
                    <div class="form-group">
                        <label for="nit">NIT</label>
                        <input type="text" class="form-control" id="nit" name="nit" value="<?= $cliente['vat_no'] ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label for="nombre">Nombre</label>
                        <input type="text" class="form-control" id="nombre" name="nombre" value="<?= $cliente['name'] ?>" readonly>
                    </div>
                    <div class="form-group">
                        <label for="direccion">Dirección</label>
                        <input type="text" class="form-control" id="direccion" name="direccion" value="<?= $cliente['address'] ?>">
                    </div>
                    <div class="form-group">
                        <label for="municipio">Municipio</label>
                        <input type="text" class="form-control" id="municipio" name="municipio" value="<?= $cliente['municipio'] ?>">
                    </div>
                    <div class="form-group">
                        <label for="departamento">Departamento</label>
                        <input type="text" class="form-control" id="departamento" name="departamento" value="<?= $cliente['departamento'] ?>">
                    </div>
                    <div class="form-group">
                        <label for="pais">País</label>
                        <input type="text" class="form-control" id="pais" name="pais" value="<?= $cliente['pais'] ?>" readonly>
                    </div>
                    <input type="hidden" name="reference_no" value="<?= $reference_no ?>">
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancelar</button>
                <button type="button" class="btn btn-primary" id="btnCertificar">Certificar</button>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#modalConfirmacion').modal('show'); // Mostrar el modal al cargar la vista

    $('#btnCertificar').click(function() {
        // Enviar los datos del formulario al controlador para certificar
        var formData = $('#formConfirmacion').serialize();
        $.ajax({
            url: '<?= admin_url('fel/certificar') ?>', // Reemplaza con la URL correcta para certificar
            type: 'POST',
            data: formData,
            dataType: 'json',
            success: function(response) {
                if (response.status === true) {
                    // Mostrar mensaje de éxito y cerrar el modal
                    alert('Factura certificada correctamente. UUID: ' + response.uuid);
                    $('#modalConfirmacion').modal('hide');
                } else {
                    // Mostrar mensaje de error
                    alert('Error al certificar la factura: ' + response.msg);
                }
            },
            error: function() {
                alert('Error al comunicarse con el servidor.');
            }
        });
    });
});
</script>