<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>

<div class="box">
    <div class="box-header">
        <h2 class="blue">
            <i class="fa-fw fa fa-certificate"></i> <?= lang('certificadores_fel'); ?>
        </h2>
        <div class="box-icon">
            <ul class="btn-tasks">
                <li class="dropdown">
                    <a data-toggle="dropdown" class="dropdown-toggle" href="#">
                        <i class="icon fa fa-tasks tip" data-placement="left"
                           title="<?= lang('actions'); ?>"></i>
                    </a>
                    <ul class="dropdown-menu pull-right tasks-menus" role="menu">
                        <li>
                            <a href="<?= admin_url('certificadores/add_certificador'); ?>"
                               data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus-circle"></i>
                                <?= lang('add_certificador'); ?>
                            </a>
                        </li>
                        <li>
                            <a href="<?= admin_url('clientes_certificador/add'); ?>"
                               data-toggle="modal" data-target="#myModal">
                                <i class="fa fa-plus-circle"></i>
                                <?= lang('add_conexion'); ?>
                            </a>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>

    <div class="box-content">
        <div class="row">
            <div class="col-lg-12">

                <?php if ($this->session->flashdata('error')): ?>
                    <div class="alert alert-danger">
                        <?= $this->session->flashdata('error'); ?>
                    </div>
                <?php endif; ?>

                <?php if ($this->session->flashdata('message')): ?>
                    <div class="alert alert-success">
                        <?= $this->session->flashdata('message'); ?>
                    </div>
                <?php endif; ?>

                <!-- ====================== CERTIFICADORES ====================== -->
                <h3><?= lang('certificadores'); ?></h3>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-condensed">
                        <thead>
                        <tr class="primary">
                            <th style="width:60px;">ID</th>
                            <th><?= lang('name'); ?></th>
                            <th><?= lang('description'); ?></th>
                            <th>API Path</th>
                            <th style="width:80px; text-align:center;"><?= lang('active'); ?></th>
                            <th style="width:120px; text-align:center;"><?= lang('actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($certificadores)): ?>
                            <?php foreach ($certificadores as $c): ?>
                                <tr>
                                    <td><?= (int)$c->id; ?></td>
                                    <td><?= htmlspecialchars($c->nombre); ?></td>
                                    <td><?= htmlspecialchars($c->descripcion); ?></td>
                                    <td><?= htmlspecialchars($c->api_path); ?></td>
                                    <td style="text-align:center;">
                                        <?= $c->activo ? lang('yes') : lang('no'); ?>
                                    </td>
                                    <td style="text-align:center;">
                                        <a href="<?= admin_url('certificadores/edit_certificador/' . $c->id); ?>"
                                           class="btn btn-warning btn-xs" data-toggle="modal"
                                           data-target="#myModal">
                                            <i class="fa fa-edit"></i>
                                        </a>
                                        <a href="<?= admin_url('certificadores/delete_certificador/' . $c->id); ?>"
                                           class="btn btn-danger btn-xs bpo"
                                           title="<b><?= lang('delete_certificador'); ?></b>"
                                           data-content="<p><?= lang('r_u_sure'); ?></p>
                                                         <button type='button' class='btn btn-danger'
                                                                 id='delete' data-action='delete'>
                                                             <?= lang('i_m_sure'); ?>
                                                         </button>
                                                         <button class='btn bpo-close'>
                                                             <?= lang('no'); ?>
                                                         </button>"
                                           data-html="true" data-placement="left">
                                            <i class="fa fa-trash-o"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="6" class="text-center">
                                    <?= lang('no_data_available'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- =================== CONEXIONES POR SUCURSAL =================== -->
                <h3 style="margin-top:30px;"><?= lang('conexiones_por_sucursal'); ?></h3>
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-condensed">
                        <thead>
                        <tr class="primary">
                            <th style="width:60px;">ID</th>
                            <th><?= lang('sucursal'); ?></th>
                            <th><?= lang('certificador'); ?></th>
                            <th><?= lang('nit'); ?></th>
                            <th><?= lang('usuario'); ?></th>
                            <th style="width:70px; text-align:center;"><?= lang('active'); ?></th>
                            <th style="width:160px; text-align:center;"><?= lang('actions'); ?></th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($conexiones)): ?>
                            <?php foreach ($conexiones as $cx): ?>
                                <?php
                                // 🔹 AQUÍ leemos el campo estado (0 / 1)
                                $conectado = (int)$cx->activo === 1;
                                ?>
                                <tr>
                                    <td><?= (int)$cx->id; ?></td>
                                    <td><?= htmlspecialchars($cx->sucursal); ?></td>
                                    <td><?= htmlspecialchars($cx->certificador); ?></td>
                                    <td><?= htmlspecialchars($cx->nit); ?></td>
                                    <td><?= htmlspecialchars($cx->usuario); ?></td>
                                    <td style="text-align:center;">
                                        <?= $cx->activo ? lang('yes') : lang('no'); ?>
                                    </td>
                                    <td style="text-align:center;">

                                        <!-- Editar conexión -->
                                        <a href="<?= admin_url('clientes_certificador/edit/' . $cx->id); ?>"
                                           class="btn btn-warning btn-xs" data-toggle="modal"
                                           data-target="#myModal">
                                            <i class="fa fa-edit"></i>
                                        </a>

                                        <!-- Eliminar conexión -->
                                        <a href="<?= admin_url('clientes_certificador/delete/' . $cx->id); ?>"
                                           class="btn btn-danger btn-xs bpo"
                                           title="<b><?= lang('delete_conexion'); ?></b>"
                                           data-content="<p><?= lang('r_u_sure'); ?></p>
                                                         <button type='button' class='btn btn-danger'
                                                                 id='delete' data-action='delete'>
                                                             <?= lang('i_m_sure'); ?>
                                                         </button>
                                                         <button class='btn bpo-close'>
                                                             <?= lang('no'); ?>
                                                         </button>"
                                           data-html="true" data-placement="left">
                                            <i class="fa fa-trash-o"></i>
                                        </a>

                                        <!-- 🔌 Botón Conectar / Desconectar según estado -->
                                        <?php if ($conectado): ?>
                                            <a href="<?= admin_url('certificadores/desconectar/' . $cx->id); ?>"
                                               class="btn btn-danger btn-xs">
                                                <i class="fa fa-unlink"></i> Desconectar
                                            </a>
                                        <?php else: ?>
                                            <a href="<?= admin_url('certificadores/conectar/' . $cx->id); ?>"
                                               class="btn btn-success btn-xs">
                                                <i class="fa fa-plug"></i> Conectar
                                            </a>
                                        <?php endif; ?>

                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="7" class="text-center">
                                    <?= lang('no_data_available'); ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>
