<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Merma_model extends CI_Model {

    // Obtener ticket de ventas
    public function get_ticket($ref) {
        $this->db->select('sma_sales.id, sma_sales.customer, sma_sales.warehouse_id, sma_warehouses.name as warehouse_name');
        $this->db->from('sma_sales');
        $this->db->join('sma_warehouses', 'sma_warehouses.id = sma_sales.warehouse_id', 'left');
        $this->db->where('sma_sales.reference_no', $ref);
        $query = $this->db->get();
        return $query->row();
    }

    // Buscar productos en todas las sucursales
    public function search_productos($term) {
        $this->db->select('p.id, p.code, p.name, wp.quantity, p.cost');
        $this->db->from('sma_products p');
        $this->db->join('sma_warehouses_products wp', 'wp.product_id = p.id', 'left');
        $this->db->like('p.name', $term);
        $this->db->or_like('p.code', $term);
        $this->db->limit(10);
        $query = $this->db->get();
        return $query->result();
    }

    // Guardar merma y actualizar inventario
    public function guardar_merma($data) {
        $this->db->trans_start();

        foreach($data['productos'] as $p){
            $merma = [
                'ticket_ref' => $data['ticket_ref'],
                'cliente' => $data['cliente'],
                'sucursal_id' => $data['sucursal_id'],
                'producto_id' => $p['id'],
                'producto_codigo' => $p['code'],
                'cantidad' => $p['cantidad'],
                'costo_oculto' => $p['cost'],
                'nota' => $data['nota'],
                'created_by' => $data['created_by'],
                'created_at' => $data['created_at'],
                'restaurado' => 0
            ];
            $this->db->insert('sma_mermas', $merma);

            // Descontar inventario en la sucursal
            $this->db->set('quantity', "quantity - {$p['cantidad']}", false);
            $this->db->where('product_id', $p['id']);
            $this->db->where('warehouse_id', $data['sucursal_id']);
            $this->db->update('sma_warehouses_products');
        }

        $this->db->trans_complete();
        return $this->db->trans_status();
    }

}
