<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FelClientHelper_model extends CI_Model {

    public function __construct() {
        parent::__construct();
    }

   public function getOrCreateByNit($nit, $datosCertificador = null)
{
    $company = $this->db
        ->where('vat_no', $nit)
        ->get('sma_companies')
        ->row_array();

    if (!$company) {

        $data = [
            'name'    => $datosCertificador['nombre'] ?? 'Consumidor Final',
            'vat_no'  => $nit,
            'address' => $datosCertificador['direccion'] ?? 'Ciudad',
            'city'    => $datosCertificador['municipio'] ?? '',
            'country' => 'GT'
        ];

        $this->db->insert('sma_companies', $data);

        $company = $this->db
            ->where('id', $this->db->insert_id())
            ->get('sma_companies')
            ->row_array();
    }

    // 🔥 NORMALIZAMOS LOS NOMBRES PARA TODO EL SISTEMA
    return [
        'vat_no'         => $company['vat_no'],
        'name'      => $company['name'],
        'address'   => $company['city'],
        'city'   => $company['city'],
        'departamento'=> '',
    ];
}

}
