<?php defined('BASEPATH') OR exit('No direct script access allowed');

class Factura_model extends CI_Model {

    public function ya_facturada($sale_id) {
        return $this->db->where('sale_id', $sale_id)
                        ->where('status !=', 'cancelled')
                        ->get('sma_sales_invoices')->num_rows() > 0;
    }

    public function guardar_factura($data) {
        $this->db->insert('sma_sales_invoices', $data);
    }

    public function get_factura($invoice_id) {
        return $this->db->get_where('sma_sales_invoices', ['id' => $invoice_id])->row();
    }

    public function cancelar_factura($invoice_id, $user_id) {
        $factura = $this->get_factura($invoice_id);
        $this->db->update('sma_sales_invoices', [
            'status' => 'cancelled',
            'cancelled_by' => $user_id,
            'cancelled_at' => date('Y-m-d H:i:s')
        ], ['id' => $invoice_id]);

        // Mover archivos a carpeta cancelada
        @rename(FCPATH . $factura->pdf_path, FCPATH . "app/factura_files/cancelled/pdf/" . basename($factura->pdf_path));
        @rename(FCPATH . $factura->xml_path, FCPATH . "app/factura_files/cancelled/xml/" . basename($factura->xml_path));
    }
}
