<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class FelService {

    private $tokenUrl;
    private $nit;
    private $user;
    private $password;

    public function __construct($tokenUrl, $nit, $user, $password) {
        $this->tokenUrl = $tokenUrl;
        $this->nit = $nit;
        $this->user = $user;
        $this->password = $password;
    }

    /**
     * Solicita el token FEL
     * @return array|false ['token'=>..., 'expires_at'=>...] o false si falla
     */
   public function requestToken() {
    $ch = curl_init();

    $nitPadded = str_pad($this->nit, 12, '0', STR_PAD_LEFT);
    $username = "GT.$nitPadded.".$this->user;

    $payload = json_encode([
        'Username' => $username,
        'Password' => $this->password
    ]);

    curl_setopt($ch, CURLOPT_URL, $this->tokenUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);

    $response = curl_exec($ch);

    if ($response === false) {
        file_put_contents('C:/xampp/htdocs/tecno/ventas/fel_debug.log', 'CURL Error: ' . curl_error($ch));
        curl_close($ch);
        return false;
    }

    curl_close($ch);

    // Guardar crudo
    file_put_contents('C:/xampp/htdocs/tecno/ventas/fel_debug.log', $response);

    $result = json_decode($response, true);

    // Guardar array también
    file_put_contents('C:/xampp/htdocs/tecno/ventas/fel_debug.log', print_r($result, true), FILE_APPEND);

    // 👇 Ajusta a las claves que realmente devuelve FEL
    if (isset($result['Token']) && isset($result['expira_en'])) {
        return [
            'Token'     => $result['Token'],
            'expira_en' => $result['expira_en'],
            'pais'      => 'GT',
            'nit'       => $this->nit,
            'usuario'   => $this->user
        ];
    }

    return false;
}



}
