<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificadores extends MY_Controller
{
    public function __construct()
    {
        parent::__construct();

        if (!$this->Owner && !$this->Admin) {
            $this->session->set_flashdata('warning', lang('access_denied'));
            admin_redirect('welcome');
        }

        $this->load->model('admin/Certificadores_model', 'certificadores_model');
        $this->load->library('form_validation');
        $this->lang->admin_load('settings', $this->Settings->user_language);
    }

    // =====================================================
    // LISTADO PRINCIPAL
    // =====================================================
    public function index()
    {
        $this->data['error'] = (validation_errors() ? validation_errors() : $this->session->flashdata('error'));
        $this->data['message'] = $this->session->flashdata('message');

        $this->data['certificadores'] = $this->certificadores_model->getallcertificadores();
        $this->data['conexiones']     = $this->certificadores_model->get_all_conexiones();

        $bc   = [
            ['link' => admin_url('welcome'), 'page' => lang('home')],
            ['link' => '#', 'page' => 'Certificadores FEL'],
        ];
        $meta = ['page_title' => 'Certificadores FEL', 'bc' => $bc];

        $this->page_construct('certificadores/index', $meta, $this->data);
    }

    // =====================================================
    // CONECTAR (MANUAL - BOTÓN)
    // =====================================================
    public function conectar($conexion_id = null)
{
    $conexion = $this->certificadores_model->get_conexion($conexion_id);
    if (!$conexion) {
        $this->session->set_flashdata('error', 'Conexión no encontrada.');
        admin_redirect('certificadores');
    }

    $certificador = $this->certificadores_model->get_certificador($conexion->certificador_id);
    if (!$certificador || !$certificador->activo) {
        $this->session->set_flashdata('error', 'Certificador no válido o inactivo.');
        admin_redirect('certificadores');
    }

    $respuesta = $this->certificadores_model->solicitar_token($certificador, $conexion);

    if ($respuesta && !empty($respuesta['token'])) {

        // 🔥 GUARDAMOS TOKEN
        $this->certificadores_model->save_or_update_token(
            $conexion->id,
            $conexion->usuario,
            $respuesta['token'],
            $respuesta['expiracion']
        );

        // 🔥 ACTIVAMOS LA CONEXIÓN (ESTO ES LO QUE TE FALTABA)
        $this->certificadores_model->update_conexion($conexion->id, [
            'activo' => 1
        ]);

        $this->session->set_flashdata('message', 'Conectado correctamente.');
    } else {
        $this->session->set_flashdata('error', 'No se pudo obtener el token del certificador.');
    }

    admin_redirect('certificadores');
}


    // =====================================================
    // DESCONECTAR (BORRAR TOKEN)
    // =====================================================
    public function desconectar($conexion_id = null)
{
    $conexion = $this->certificadores_model->get_conexion($conexion_id);

    if (!$conexion) {
        $this->session->set_flashdata('error', 'Conexión no encontrada.');
        admin_redirect('certificadores');
    }

    // 🔥 SOLO desactivamos (NO borramos token histórico)
    $this->certificadores_model->update_conexion($conexion->id, [
        'activo' => 0
    ]);

    $this->session->set_flashdata('message', 'Conexión desactivada correctamente.');

    admin_redirect('certificadores');
}

// ======================================================
// CRON AUTOMÁTICO → RENOVACIÓN DE TOKENS
// URL: /admin/certificadores/renovar_cron/MI_CLAVE_SECRETA
// ======================================================
public function renovar_cron($key = null)
{
    $clave_configurada = 'MI_CLAVE_SECRETA';

    if ($key !== $clave_configurada) {
        show_404();
    }

    $this->load->model('admin/certificadores_model');

    // Solo activos
    $this->db->select('c.*, ce.*');
    $this->db->from('sma_clientes_certificador_conexion c');
    $this->db->join('sma_certificadores ce', 'ce.id = c.certificador_id');

    $this->db->where('c.activo', 1);
    $this->db->where('ce.activo', 1);

    $conexiones = $this->db->get()->result();

    foreach ($conexiones as $conexion) {

        // usamos la función inteligente del modelo
        $this->certificadores_model->get_token_valido($conexion, $conexion);

        log_message('error', 'Token verificado para conexión ID: ' . $conexion->id);
    }

    echo "RENOVACION OK";
}

}
