<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Certificadores_model extends CI_Model
{
    public function __construct()
    {
        parent::__construct();
    }

    public function addCertificador($data)
    {
        if ($this->db->insert('sma_certificadores', $data)) {
            return $this->db->insert_id();
        }
        return false;
    }

    public function updateCertificador($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('sma_certificadores', $data);
    }

    public function deleteCertificador($id)
    {
        return $this->db->delete('sma_certificadores', ['id' => $id]);
    }

    public function getCertificadorByID($id)
    {
        $q = $this->db->get_where('sma_certificadores', ['id' => $id], 1);
        return ($q->num_rows() > 0) ? $q->row() : false;
    }

    public function getAllCertificadores()
    {
        $q = $this->db->get('sma_certificadores');
        return ($q->num_rows() > 0) ? $q->result() : false;
    }

    public function getCertificadorSuggestions($term, $limit = 10)
    {
        $this->db->select('id, nombre as text');
        $this->db->like('nombre', $term);
        $q = $this->db->get('sma_certificadores', $limit);
        return ($q->num_rows() > 0) ? $q->result() : false;
    }
}